/*
 * Decompiled with CFR 0.152.
 */
package jclass.field;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import jclass.bwt.JCTextInterface;
import jclass.bwt.JCTextManagerInterface;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorListener;
import jclass.cell.CellInfo;
import jclass.cell.CellRenderer;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.Utilities;
import jclass.cell.ValidateInterface;
import jclass.cell.ValidateListener;
import jclass.field.JCField;
import jclass.field.JCFieldListener;
import jclass.field.JCSpin;
import jclass.field.JCSpinInterface;
import jclass.field.JCValidateInterface;
import jclass.field.JCValidator;
import jclass.field.JCVersion;
import jclass.util.JCVector;

public abstract class JCFieldSpin
extends JCSpin
implements JCSpinInterface,
JCTextManagerInterface,
CellEditor,
CellRenderer,
ValidateInterface {
    private static final boolean TRACE = false;
    public static final String version = JCVersion.getVersionString();
    public static final String about = JCVersion.getAboutString();
    protected JCVector spin_listeners = new JCVector(0);
    protected JCField field;
    protected int position = -1;
    protected String[] display_list;
    protected String value;

    protected void createField(JCValidator jCValidator, Object object, Object object2) {
        this.field = new JCField(this, jCValidator, object, object2);
        this.setValue(this.field.getValue());
    }

    public JCField getField() {
        return this.field;
    }

    public JCValidateInterface getValidator() {
        return this.field.getValidator();
    }

    public void setValidator(JCValidateInterface jCValidateInterface) {
        this.field.setValidator(jCValidateInterface);
    }

    public void setText(String string) {
        if (this.field != null && this.field.getAllowTextChange()) {
            super.setText(string);
        }
    }

    public void setValue(Object object) {
        this.field.setValue(object);
        this.checkArrowButtons();
    }

    public void setEditable(boolean bl) {
        this.text.setEditable(bl);
        this.field.setValue(this.field.getValue());
    }

    protected boolean validate(Object object) {
        return true;
    }

    public synchronized JCTextInterface getTextComponent() {
        return this.text;
    }

    public void checkArrowButtons() {
        if (this.field == null || this.field.getValidator() == null) {
            this.incr_arrow.enable(false);
            this.decr_arrow.enable(false);
            return;
        }
        int n = this.field.getState() == 2 || this.field.getValue() == null ? this.field.getValidator().calculateSpinability(this.field.getDefaultValue()) : this.field.getValidator().calculateSpinability(this.field.getValue());
        if (this.incr_arrow != null) {
            this.incr_arrow.enable((n & 1) != 0);
        }
        if (this.decr_arrow != null) {
            this.decr_arrow.enable((n & 2) != 0);
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.field.text != null) {
            this.field.setValidBackground(((Component)((Object)this.field.text)).getBackground());
            this.field.setValidForeground(((Component)((Object)this.field.text)).getForeground());
        } else {
            this.field.setValidBackground(this.field.vc.getBackground());
            this.field.setValidForeground(this.field.vc.getForeground());
        }
        this.setValue(this.field.getValue());
    }

    public char getEchoChar() {
        return this.getTextField().getEchoChar();
    }

    public void setEchoChar(char c) {
        this.getTextField().setEchoChar(c);
    }

    public String getEchoCharString() {
        return this.getTextField().getEchoCharString();
    }

    public void setEchoCharString(String string) {
        this.getTextField().setEchoCharString(string);
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String string) {
    }

    public String getAbout() {
        return about;
    }

    public synchronized void setAbout(String string) {
    }

    public boolean getBeepOnInvalid() {
        return this.field.getBeepOnInvalid();
    }

    public void setBeepOnInvalid(boolean bl) {
        this.field.setBeepOnInvalid(bl);
    }

    public Color getInvalidBackground() {
        return this.field.getInvalidBackground();
    }

    public void setInvalidBackground(Color color) {
        this.field.setInvalidBackground(color);
    }

    public Color getInvalidForeground() {
        return this.field.getInvalidForeground();
    }

    public void setInvalidForeground(Color color) {
        this.field.setInvalidForeground(color);
    }

    public Color getValidBackground() {
        return this.field.getValidBackground();
    }

    public void setValidBackground(Color color) {
        this.field.setValidBackground(color);
    }

    public Color getValidForeground() {
        return this.field.getValidForeground();
    }

    public void setValidForeground(Color color) {
        this.field.setValidForeground(color);
    }

    public int getInvalidPolicy() {
        return this.field.getInvalidPolicy();
    }

    public void setInvalidPolicy(int n) {
        this.field.setInvalidPolicy(n);
    }

    public int getState() {
        return this.field.getState();
    }

    public void setState(int n) {
    }

    public void addFieldListener(JCFieldListener jCFieldListener) {
        this.field.addFieldListener(jCFieldListener);
    }

    public void removeFieldListener(JCFieldListener jCFieldListener) {
        this.field.removeFieldListener(jCFieldListener);
    }

    public String getPromptText() {
        return this.field.getPromptText();
    }

    public void setPromptText(String string) {
        this.field.setPromptText(string);
    }

    public Component getPromptTarget() {
        return this.field.getPromptTarget();
    }

    public void setPromptTarget(Component component) {
        this.field.setPromptTarget(component);
    }

    public String[] getDisplayList() {
        return this.field.getDisplayList();
    }

    public void setDisplayList(String[] stringArray) {
        this.field.setDisplayList(stringArray);
        this.field.setValue(this.field.getValue());
    }

    public boolean getAllowNull() {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return false;
        }
        return jCValidator.getAllowNull();
    }

    public void setAllowNull(boolean bl) {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setAllowNull(bl);
    }

    public String getValidChars() {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return null;
        }
        return jCValidator.getValidChars();
    }

    public void setValidChars(String string) {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setValidChars(string);
    }

    public String getInvalidChars() {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return null;
        }
        return jCValidator.getInvalidChars();
    }

    public void setInvalidChars(String string) {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setInvalidChars(string);
    }

    public int getCasePolicy() {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return 0;
        }
        return jCValidator.getCasePolicy();
    }

    public void setCasePolicy(int n) {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setCasePolicy(n);
    }

    public boolean getMatchPickList() {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return true;
        }
        return jCValidator.getMatchPickList();
    }

    public void setMatchPickList(boolean bl) {
        JCValidator jCValidator = (JCValidator)this.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setMatchPickList(bl);
        this.field.setValue(this.field.getValue());
    }

    public int getSpinPolicy() {
        JCValidator jCValidator = (JCValidator)this.field.getValidator();
        if (jCValidator == null) {
            return 0;
        }
        return jCValidator.getSpinPolicy();
    }

    public void setSpinPolicy(int n) {
        JCValidator jCValidator = (JCValidator)this.field.getValidator();
        if (jCValidator == null) {
            return;
        }
        jCValidator.setSpinPolicy(n);
    }

    public void addValidateListener(ValidateListener validateListener) {
        this.field.addValidateListener(validateListener);
    }

    public void removeValidateListener(ValidateListener validateListener) {
        this.field.removeValidateListener(validateListener);
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.field.initialize(initialEvent, cellInfo, object);
        this.setHighlightThickness(0);
        this.text.setHighlightThickness(0);
        this.setInsets(new Insets(0, 0, 0, 0));
        this.text.setInsets(cellInfo.getMarginInsets());
        this.setShadowThickness(cellInfo.getBorderInsets().top);
        this.setAlignment(cellInfo.getHorizontalAlignment());
        ((Component)this).setFont(cellInfo.getFont());
        this.setBackground(cellInfo.getBackground());
        this.setForeground(cellInfo.getForeground());
        this.setSelectedBackground(cellInfo.getSelectedBackground());
        this.setSelectedForeground(cellInfo.getSelectedForeground());
        this.text.containedInitialize(initialEvent, cellInfo, object);
    }

    public Component getComponent() {
        return this;
    }

    public boolean stopCellEditing() {
        return this.field.stopCellEditing();
    }

    public Object getCellEditorValue() {
        return this.field.getValue();
    }

    public boolean isModified() {
        return this.field.isModified();
    }

    public void cancelCellEditing() {
        this.text.cancelCellEditing();
    }

    public KeyModifier[] getReservedKeys() {
        KeyModifier[] keyModifierArray = Utilities.addKey(this.text.getReservedKeys(), new KeyModifier(27, 16));
        keyModifierArray = Utilities.addKey(keyModifierArray, new KeyModifier(38, 0));
        keyModifierArray = Utilities.addKey(keyModifierArray, new KeyModifier(40, 0));
        return keyModifierArray;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.text.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.text.removeCellEditorListener(cellEditorListener);
    }

    public void draw(Graphics graphics, CellInfo cellInfo, Object object, boolean bl) {
        String string = this.field.getValidator().format(object);
        this.text.draw(graphics, cellInfo, string, bl);
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        String string = this.field.getValidator().format(object);
        return this.text.getPreferredSize(cellInfo, string);
    }
}

